.386
.model flat,stdcall
option casemap:none
include windows.inc
include user32.inc
include kernel32.inc
include comctl32.inc
includelib comctl32.lib
includelib user32.lib
includelib kernel32.lib
include shell32.inc
includelib shell32.lib

WinMain proto :DWORD,:DWORD,:DWORD,:DWORD
AddProc proto :DWORD,:DWORD,:DWORD,:DWORD
SaveProcedure proto
InsertColumn proto :DWORD
EditProc proto :DWORD,:DWORD,:DWORD,:DWORD
SearchProc proto :DWORD,:DWORD,:DWORD,:DWORD

RGB macro red,green,blue
        xor eax,eax
        mov ah,blue
        shl eax,8
        mov ah,green
        mov al,red
endm

.const
IDD_DIALOG2				=   102
IDD_DIALOG1              =       101
IDC_EDIT1                 =      1000
IDC_EDIT2                    =   1001
IDC_EDIT3                  =     1002
IDC_EDIT4                   =    1003
IDC_BUTTON2                =     1004
IDC_BUTTON1                 =    1005
IDC_STATIC                 =     -1

ID_LVSELLECTALL equ 00000020h
ID_LVDRAGCOLUMN equ 00000010h

IDI_ICON1                       =101
IDR_MENU1                       =101
IDM_EXIT=                  40003
IDM_ADD   =                 40004
IDM_DEL  =        40006
IDM_EDIT   =          40007
IDM_ABOUT   =           40008
IDM_BUGS     =                  40009
IDM_HOMEPAGE   =        40010
IDM_SEARCH     =        40013
DIVSIGN	= 		1
MAX_STRING = 500

IDD_SEARCH                  =     9101
IDC_LIST1                   =    9000
IDC_EDITSEARCH              =         9001
IDC_SEARCH                  =9002

.data
searchstring db 250 dup(0)
BugsMsg db "mailto:rnowicki@inetia.pl",0
url db "www.nowicki.cjb.net",0
helpfile db "files\readme.txt",0
mailcmd db "mailto:",0
email db 200 dup(0)
emptystring db 0
command db "open",0
divstring db 1,0
text db MAX_STRING dup(0)
MenuDel db "Delete Contact",0
MenuAdd db "Add Contact",0
MenuEdit db "Edit Contact",0
DataFileName db "files\abook.dat",0
Error db "What should I looking for man?",0
ClassName db "ListViewWinClass",0
AppName  db "Address Book",0
ListViewClassName db "SysListView32",0
AccelTab db "MAINACCEL",0
H1 db "Name",0
H2 db "Phone",0
H3 db "E-mail",0
H4 db "Address",0
lvi LV_ITEM <LVIF_TEXT,0,0,LVIS_FOCUSED,0,text,MAX_STRING,0,0>
lvisearch LV_ITEM <LVIF_TEXT,0,0,LVIS_FOCUSED,0,text,MAX_STRING,0,0>

.data?
recure db ?
SizeRW dd ?
hInstance HINSTANCE ?
hList  dd  ?
hMenu dd ?
hMenu1 dd ?
pMemory dd ?
hMemory dd ?
hAcceltab HINSTANCE ?
FileSize dd ?
hFile dd ?
hSearchBox dd ?
iloscwierszy dd ?

.code
start:
	invoke GetModuleHandle, NULL
	mov    hInstance,eax
	invoke WinMain, hInstance,NULL, NULL, SW_SHOWDEFAULT
	invoke ExitProcess,eax
	invoke InitCommonControls

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
	LOCAL wc:WNDCLASSEX
	LOCAL msg:MSG
	LOCAL hwnd:HWND
	mov   wc.cbSize,SIZEOF WNDCLASSEX
	mov   wc.style, NULL
	mov   wc.lpfnWndProc, OFFSET WndProc
	mov   wc.cbClsExtra,NULL
	mov   wc.cbWndExtra,NULL
	push  hInstance
	pop   wc.hInstance
	mov   wc.hbrBackground,COLOR_WINDOW+1
	mov   wc.lpszMenuName,IDR_MENU1
	mov   wc.lpszClassName,OFFSET ClassName
	invoke LoadIcon,hInstance,IDI_ICON1
	mov   wc.hIcon,eax
	mov   wc.hIconSm,eax
	invoke LoadCursor,NULL,IDC_ARROW
	mov   wc.hCursor,eax
	invoke RegisterClassEx, addr wc
	INVOKE CreateWindowEx,NULL,ADDR ClassName,ADDR AppName,\
           WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,CW_USEDEFAULT,640,400,NULL,NULL,\
           hInst,NULL
	mov   hwnd,eax
	invoke ShowWindow, hwnd,SW_SHOWNORMAL
	invoke UpdateWindow, hwnd
	
	invoke LoadAccelerators,hInst,addr AccelTab
	mov hAcceltab,eax

	msg_loop:
		invoke GetMessage, ADDR msg,NULL,0,0
		cmp eax,0
		je quit
		invoke TranslateAccelerator,hwnd,hAcceltab,addr msg
		cmp eax,0
		jne msg_loop
		invoke TranslateMessage, ADDR msg
		invoke DispatchMessage, ADDR msg
		jmp msg_loop
	quit:
	mov     eax,msg.wParam
	ret
WinMain endp

InsertColumn proc h2List:DWORD
	LOCAL lvc:LV_COLUMN
	mov lvc.imask,LVCF_TEXT+LVCF_WIDTH
	mov lvc.pszText,offset H1
	mov lvc.lx,150
	invoke SendMessage,h2List, LVM_INSERTCOLUMN,0,addr lvc
	or lvc.imask,LVCF_FMT
	mov lvc.fmt,LVCFMT_LEFT
	mov lvc.pszText,offset H2
	mov lvc.lx,100
	invoke SendMessage,h2List, LVM_INSERTCOLUMN, 1 ,addr lvc
	or lvc.imask,LVCF_FMT
	mov lvc.fmt,LVCFMT_LEFT
	mov lvc.pszText,offset H3
	mov lvc.lx,150
	invoke SendMessage,h2List, LVM_INSERTCOLUMN, 2 ,addr lvc
	or lvc.imask,LVCF_FMT
	mov lvc.fmt,LVCFMT_LEFT
	mov lvc.pszText,offset H4
	mov lvc.lx,230
	invoke SendMessage,h2List, LVM_INSERTCOLUMN, 3 ,addr lvc
	ret		
InsertColumn endp

WndProc proc hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
LOCAL pt:POINT

	.if uMsg==WM_CREATE
		invoke CreateWindowEx, NULL, addr ListViewClassName, NULL,LVS_SORTASCENDING+LVS_REPORT+WS_CHILD+WS_VISIBLE, 0,0,0,0,hWnd, NULL, hInstance, NULL
		mov hList, eax
		invoke InsertColumn,hList
             mov eax, ID_LVSELLECTALL or ID_LVDRAGCOLUMN
           INVOKE SendMessage, hList, LVM_FIRST + 54, 0, eax
		mov eax, 20h
	      INVOKE SendMessage, hList, LVM_FIRST + 54, 0, eax

		RGB 255,255,255
		invoke SendMessage,hList,LVM_SETTEXTCOLOR,0,eax
		RGB 5,75,146
		invoke SendMessage,hList,LVM_SETBKCOLOR,0,eax
		RGB 5,75,146
		invoke SendMessage,hList,LVM_SETTEXTBKCOLOR,0,eax

	invoke CreatePopupMenu
	mov hMenu1,eax
	invoke AppendMenu,hMenu1,MF_STRING,IDM_DEL,addr MenuDel
	invoke AppendMenu,hMenu1,MF_STRING,IDM_ADD,addr MenuAdd
	invoke AppendMenu,hMenu1,MF_SEPARATOR,0,0
	invoke AppendMenu,hMenu1,MF_STRING,IDM_EDIT,addr MenuEdit

invoke CreateFile,addr DataFileName,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_READ,0,\
		OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
mov hFile,eax
invoke GetFileSize,eax,addr FileSize
mov FileSize,eax
invoke GlobalAlloc,GMEM_MOVEABLE or GMEM_ZEROINIT,FileSize
mov hMemory,eax
invoke GlobalLock,hMemory
mov pMemory,eax
invoke ReadFile,hFile,pMemory,FileSize,ADDR SizeRW,NULL
mov iloscwierszy,0


;------------------------
push edi
push esi

mov ecx,FileSize
cmp ecx,0
je finishopen
add ecx,1
push ecx
mov esi,pMemory
xor eax,eax
jmp clearstring2

compare1:
pop ecx
dec ecx
jz finishopen
push ecx
mov al,[esi]
inc esi
cmp al,DIVSIGN
je SendString
mov [edi],al
inc edi
jmp compare1


SendString:
inc recure 	

.if recure==1
mov eax,iloscwierszy
mov lvi.iItem,eax
mov lvi.iSubItem,0
invoke SendMessage,hList,LVM_INSERTITEM,0,addr lvi

.elseif recure==4
inc lvi.iSubItem
invoke SendMessage,hList,LVM_SETITEM,0,addr lvi
inc iloscwierszy
mov recure,0

.else
inc lvi.iSubItem
invoke SendMessage,hList,LVM_SETITEM,0,addr lvi
.endif

xor eax,eax
clearstring2:
mov text[eax],0
inc eax
cmp eax,MAX_STRING
jne clearstring2
lea edi,text 
jmp compare1


finishopen:
pop esi
pop edi
invoke GlobalUnlock,pMemory
invoke GlobalFree,hMemory
invoke CloseHandle,hFile

;---------------------------

	.elseif uMsg==WM_CLOSE
		invoke SaveProcedure
		invoke PostQuitMessage,NULL

	.elseif uMsg==WM_COMMAND
	.if lParam==0
	mov eax,wParam
	and 	eax, 0000FFFFh 	; LOWORD(wParam)
		.if eax==IDM_EXIT
			invoke SaveProcedure
			invoke PostQuitMessage,NULL
		.elseif eax==IDM_ADD
			invoke DialogBoxParam,hInstance,IDD_DIALOG1,hWnd,addr AddProc,NULL
		.elseif eax==IDM_DEL
			.if iloscwierszy!=0
				invoke SendMessage,hList,LVM_GETNEXTITEM,-1,LVNI_FOCUSED
				.if eax!=-1
					invoke SendMessage,hList,LVM_DELETEITEM,eax,0
					dec iloscwierszy
				.endif
			.endif
		.elseif eax==IDM_EDIT
			invoke SendMessage,hList,LVM_GETNEXTITEM,-1,LVNI_FOCUSED
				.if eax!=-1
					invoke DialogBoxParam,hInstance,IDD_DIALOG2,hWnd,addr EditProc,eax
				.endif
    .elseif eax==IDM_SEARCH
            invoke DialogBoxParam,hInstance,IDD_SEARCH,hWnd,addr SearchProc,NULL
		.elseif eax==IDM_ABOUT
				invoke ShellExecute,NULL,ADDR command,ADDR helpfile,NULL,NULL,SW_RESTORE
		.elseif eax==IDM_BUGS
				invoke ShellExecute,NULL,ADDR command,ADDR BugsMsg,NULL,NULL,SW_RESTORE
		.elseif eax==IDM_HOMEPAGE
				invoke ShellExecute,NULL,ADDR command,ADDR url,NULL,NULL,SW_RESTORE

		.endif
	.endif
	.elseif uMsg==WM_NOTIFY
	push edi
	mov edi,lParam
	assume edi:ptr NMHDR
	mov eax,[edi].hwndFrom
	.if eax==hList
		.if [edi].code==NM_DBLCLK
			invoke SendMessage,hList,LVM_GETNEXTITEM,-1,LVNI_FOCUSED
			.if eax!=-1
				mov lvi.iSubItem,2
				invoke SendMessage,hList,LVM_GETITEMTEXT,eax,addr lvi
				invoke lstrlen,addr text
				.if eax!=0
					invoke lstrcpy,addr email,addr mailcmd
					invoke lstrcat,addr email,addr text
					invoke ShellExecute,NULL,ADDR command,ADDR email,NULL,NULL,SW_RESTORE
				.endif
			.endif

		.elseif [edi].code==NM_RCLICK
			invoke GetCursorPos,addr pt
			invoke TrackPopupMenu,hMenu1,TPM_RIGHTALIGN,pt.x,pt.y,\
					NULL,hWnd,NULL
		.endif
	.endif
	pop edi


	.elseif uMsg==WM_SIZE
		mov eax,lParam
		mov edx,eax
		and eax,0ffffh
		shr edx,16
		invoke MoveWindow,hList, 0, 0, eax,edx,TRUE
	.elseif uMsg==WM_DESTROY
		invoke PostQuitMessage,NULL
	.else
		invoke DefWindowProc,hWnd,uMsg,wParam,lParam		
		ret
	.endif
	xor eax,eax
	ret
WndProc endp

AddProc proc hAddDlg:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
LOCAL lv_findinfo: LV_FINDINFO 


.if uMsg==WM_CLOSE

	invoke EndDialog,hAddDlg,NULL

.elseif uMsg==WM_INITDIALOG
	invoke GetDlgItem,hAddDlg,IDC_EDIT1
	invoke SetFocus,eax

.elseif uMsg==WM_COMMAND
	mov eax,wParam
		.if ax==IDC_BUTTON1
			invoke SendMessage,hAddDlg,WM_CLOSE,NULL,NULL
		.elseif ax==IDC_BUTTON2
			invoke GetDlgItemText,hAddDlg,IDC_EDIT1,addr text,MAX_STRING
			mov lvi.iSubItem,0
			invoke SendMessage,hList,LVM_INSERTITEM,0,addr lvi
			mov lv_findinfo.flags,LVFI_STRING
			mov lv_findinfo.psz,offset text
			invoke SendMessage,hList,LVM_FINDITEM,-1,addr lv_findinfo
			mov lvi.iItem,eax

			invoke GetDlgItemText,hAddDlg,IDC_EDIT2,addr text,MAX_STRING
			inc lvi.iSubItem
			invoke SendMessage,hList,LVM_SETITEM,0,addr lvi

			invoke GetDlgItemText,hAddDlg,IDC_EDIT3,addr text,MAX_STRING
			inc lvi.iSubItem
			invoke SendMessage,hList,LVM_SETITEM,0,addr lvi

			invoke GetDlgItemText,hAddDlg,IDC_EDIT4,addr text,MAX_STRING
			inc lvi.iSubItem
			invoke SendMessage,hList,LVM_SETITEM,0,addr lvi

			inc iloscwierszy
			invoke SendMessage,hAddDlg,WM_CLOSE,NULL,NULL
		

		.endif

.else 
	mov eax,FALSE
	ret
.endif
mov eax,TRUE
ret
AddProc endp

SaveProcedure proc
LOCAL idcolumn	:DWORD
LOCAL idvers	:DWORD

	mov eax,iloscwierszy
	mov ecx,1000
	mul ecx
	invoke GlobalAlloc,GPTR,ecx
	mov hMemory,eax
	invoke GlobalLock,hMemory
	mov pMemory,eax
	mov idvers,0
	mov idcolumn,0
	cmp iloscwierszy,0
	je endsave

	copy_to_memory:
	mov eax,idcolumn
	mov lvi.iSubItem,eax
	invoke lstrcpy,addr text, addr emptystring
	invoke SendMessage,hList,LVM_GETITEMTEXT,idvers,addr lvi
	invoke lstrcat,pMemory,addr text
	invoke lstrcat,pMemory,addr divstring
	cmp idcolumn,3
	je przesun_wiersz
	inc idcolumn
	jmp copy_to_memory

	przesun_wiersz:
	inc idvers
	mov eax,idvers
	cmp iloscwierszy,eax
	je endsave
	mov idcolumn,0
	jmp copy_to_memory	

endsave:
invoke CreateFile,addr DataFileName,GENERIC_READ or GENERIC_WRITE ,\
                   FILE_SHARE_READ + FILE_SHARE_WRITE,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
mov hFile,eax

invoke SetFilePointer,hFile,0,0,FILE_BEGIN
invoke lstrlen,pMemory
invoke WriteFile,hFile,pMemory,eax,addr SizeRW,NULL
invoke GlobalUnlock,pMemory
invoke GlobalFree,hMemory
invoke CloseHandle,hFile
ret
SaveProcedure endp

EditProc proc hEditDlg:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
LOCAL lv_findinfo: LV_FINDINFO 

.if uMsg==WM_INITDIALOG
	mov lvi.iSubItem,0
	invoke SendMessage,hList,LVM_GETITEMTEXT,lParam,addr lvi
	invoke SetDlgItemText,hEditDlg,IDC_EDIT1,addr text
	inc lvi.iSubItem
	invoke lstrcpy,addr text,addr emptystring
	invoke SendMessage,hList,LVM_GETITEMTEXT,lParam,addr lvi
	invoke SetDlgItemText,hEditDlg,IDC_EDIT2,addr text
	inc lvi.iSubItem
	invoke lstrcpy,addr text,addr emptystring
	invoke SendMessage,hList,LVM_GETITEMTEXT,lParam,addr lvi
	invoke SetDlgItemText,hEditDlg,IDC_EDIT3,addr text
	inc lvi.iSubItem
	invoke lstrcpy,addr text,addr emptystring
	invoke SendMessage,hList,LVM_GETITEMTEXT,lParam,addr lvi
	invoke SetDlgItemText,hEditDlg,IDC_EDIT4,addr text
	invoke SendMessage,hList,LVM_DELETEITEM,lParam,0

.elseif uMsg==WM_COMMAND
	mov eax,wParam
		.if ax==1005
			invoke GetDlgItemText,hEditDlg,IDC_EDIT1,addr text,MAX_STRING
			mov lvi.iSubItem,0
			invoke SendMessage,hList,LVM_INSERTITEM,0,addr lvi
			mov lv_findinfo.flags,LVFI_STRING
			mov lv_findinfo.psz,offset text
			invoke SendMessage,hList,LVM_FINDITEM,-1,addr lv_findinfo
			mov lvi.iItem,eax

			invoke GetDlgItemText,hEditDlg,IDC_EDIT2,addr text,MAX_STRING
			inc lvi.iSubItem
			invoke SendMessage,hList,LVM_SETITEM,0,addr lvi

			invoke GetDlgItemText,hEditDlg,IDC_EDIT3,addr text,MAX_STRING
			inc lvi.iSubItem
			invoke SendMessage,hList,LVM_SETITEM,0,addr lvi

			invoke GetDlgItemText,hEditDlg,IDC_EDIT4,addr text,MAX_STRING
			inc lvi.iSubItem
			invoke SendMessage,hList,LVM_SETITEM,0,addr lvi

			invoke EndDialog,hEditDlg,NULL
		.endif
.else 
	mov eax,FALSE
	ret
.endif
mov eax,TRUE
ret
EditProc endp

SearchProc proc hSearch:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
LOCAL itemindex :DWORD
LOCAL licznik :DWORD
	mov edx,wParam
	mov eax,edx
	shr edx,16

.if uMsg==WM_CLOSE
    invoke EndDialog,hSearch,NULL
.elseif uMsg==WM_INITDIALOG
           invoke GetDlgItem,hSearch,IDC_LIST1
           mov hSearchBox,eax
           invoke InsertColumn,hSearchBox
           mov eax, ID_LVSELLECTALL or ID_LVDRAGCOLUMN
           INVOKE SendMessage, hSearchBox, LVM_FIRST + 54, 0, eax


.ELSEIF uMsg==WM_NOTIFY
	push edi
	mov edi,lParam
	mov ebx,lParam
	assume edi:ptr NMHDR
	mov eax,[edi].hwndFrom
	.if eax==hSearchBox
		.if [edi].code==NM_DBLCLK
  		invoke SendMessage,hSearchBox,LVM_GETNEXTITEM,-1,LVNI_FOCUSED
			.if eax!=-1
				mov lvi.iSubItem,2
				invoke SendMessage,hSearchBox,LVM_GETITEMTEXT,eax,addr lvi
				invoke lstrlen,addr text
				.if eax!=0
					invoke lstrcpy,addr email,addr mailcmd
					invoke lstrcat,addr email,addr text
					invoke ShellExecute,NULL,ADDR command,ADDR email,NULL,NULL,SW_RESTORE
				.endif
			.endif
   .endif
   .endif

.elseif uMsg==WM_COMMAND
        .IF dx==BN_CLICKED
            .IF eax==IDC_SEARCH
                 invoke SendMessage,hSearchBox,LVM_DELETEALLITEMS,0,0
                 invoke GetDlgItemText,hSearch,IDC_EDITSEARCH,addr searchstring,250
                 invoke lstrlen,addr searchstring
                 .if eax!=0
                     mov itemindex,0
                     mov lvi.iSubItem,0

                     porownuj:
                              mov ecx,iloscwierszy
                              .if ecx==itemindex
                              jmp powrot
                              .endif
                              invoke SendMessage,hList,LVM_GETITEMTEXT,itemindex,addr lvi

                              push edi
                              push esi
                              lea esi,searchstring
                              lea edi,text
                              invoke lstrlen,addr text
                              mov licznik,eax

                              przewin_:
                              mov al,[esi]
                              cmp al,'?'
                              jne dalej1_
                              cmp al,'*'
                              jne dalej1_
                              inc esi
                              jmp przewin_

                              dalej1_:
                              cmp al,[edi]
                              je step0_
                              sub al,32
                              cmp al,[edi]
                              je step0_
                              inc edi
                              dec licznik
                              jz no_match1
                              jmp przewin_

                              step0_:
                              inc esi
                              inc edi

                              step1_:
                              mov al,[esi]
                              cmp al,0
                              je match1
                              cmp al,'?'
                              jne step2_
                              inc esi
                              inc edi
                              jmp step1_

                              step2_:
                              cmp al,'*'
                              jne step3_
                              inc esi
                              przewin1_:
                              mov al,[esi]
                              cmp al,[edi]
                              je step0_
                              sub al,32
                              cmp al,[edi]
                              je step0_
                              inc edi
                              jmp przewin1_

                              step3_:
                              cmp al,[edi]
                              jne step4_
                              inc esi
                              inc edi
                              jmp step1_

                              step4_:
                              sub al,32
                              cmp al,[edi]
                              jne step41_
                              inc esi
                              inc edi
                              jmp step1_
                              step41_:
                              lea esi,searchstring
                              jmp przewin_

                              no_match1:
                              .if lvi.iSubItem==4
                              inc itemindex
                              mov lvi.iSubItem,0
                              .else
                              inc lvi.iSubItem
                              .endif
                              jmp porownuj

                              match1:
                              mov lvi.iSubItem,0
                              mov lvisearch.iSubItem,0
                              invoke lstrcpy,addr text,addr emptystring
                              invoke SendMessage,hList,LVM_GETITEMTEXT,itemindex,addr lvi
                              invoke SendMessage,hSearchBox,LVM_INSERTITEM,0,addr lvisearch
                              inc lvi.iSubItem
                              inc lvisearch.iSubItem
                              invoke lstrcpy,addr text,addr emptystring
                              invoke SendMessage,hList,LVM_GETITEMTEXT,itemindex,addr lvi
                              invoke SendMessage,hSearchBox,LVM_SETITEM,0,addr lvisearch
                              inc lvi.iSubItem
                              inc lvisearch.iSubItem
                              invoke lstrcpy,addr text,addr emptystring
                              invoke SendMessage,hList,LVM_GETITEMTEXT,itemindex,addr lvi
                              invoke SendMessage,hSearchBox,LVM_SETITEM,0,addr lvisearch
                              inc lvi.iSubItem
                              inc lvisearch.iSubItem
                              invoke lstrcpy,addr text,addr emptystring
                              invoke SendMessage,hList,LVM_GETITEMTEXT,itemindex,addr lvi
                              invoke SendMessage,hSearchBox,LVM_SETITEM,0,addr lvisearch

                              mov lvi.iSubItem,0
                              inc itemindex
                              jmp porownuj

                              powrot:

                       .else
                            invoke MessageBox,NULL,addr Error,addr AppName,MB_OK
                       .endif

                  .endif
                .endif

.else
mov eax,FALSE
ret
.endif
mov eax,TRUE
ret
SearchProc endp

end start
